﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Custom/BPR/BPR.Master" AutoEventWireup="true" Inherits="VIRP_WEB.Custom.BPR.QuestionTool.ToolQuestionGroupList" Codebehind="ToolQuestionGroupList.aspx.cs" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="Server">

    <script type="text/javascript">

        $(function() {
            if ($('#<%# HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%# TextBoxKeyWords.ClientID %>').focus();

        });
    </script>

    <div class="breadcrumb">
        <asp:Label ID="BreadCrumbLabel" runat="server" Text="Follow-up Question Tool > Question Group List" />
    </div>
    <div class="excludeSaveWarnings">
        <asp:LinkButton ID="ButtonAddQuestionGroup" runat="server" Text="Add New Question Group" PostBackUrl="ToolQuestionGroupEdit.aspx?id=0" />
        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
        <asp:LinkButton ID="LinkButtonQuestionList" runat="server" Text="Go to Question List" PostBackUrl="ToolQuestionList.aspx" />
       <br />    <br />
        <asp:Panel ID="PanelListQuestions" runat="server" GroupingText="Manage Question Groups&nbsp;&nbsp;"
            Width="100%">
            <table>
                <tr>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelForTextBoxKeyWords" runat="server" Text="Filter By Key Words:"
                            AssociatedControlID="TextBoxKeyWords" ToolTip="Filter By Key Words" />                       
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelForDropDownListStatus" runat="server" Text="Filter By Status:"
                            AssociatedControlID="DropDownListStatus" ToolTip="Filter by Status" /> &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                     </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelforDropDownListSystemWide" runat="server" Text="System Wide Flag:"
                            AssociatedControlID="DropDownListSystemWide" ToolTip="Filter by System Wide Flag" /> &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                     </td>
                    <td>
                    </td>
                 </tr>
                <tr>
                    <td><asp:TextBox ID="TextBoxKeyWords" runat="server" Width="250" ToolTip="Filter By Key Words"></asp:TextBox>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp 
                    </td>
                    <td>
                         <asp:DropDownList runat='server' ID='DropDownListStatus' ToolTip='Filter by Status'>
                            <asp:ListItem Value='' Text='All' />
                            <asp:ListItem Value='1' Text='In Progress' />
                            <asp:ListItem Value='2' Text='Completed' />
                            <asp:ListItem Value='3' Text='Deactivated' />
                        </asp:DropDownList>
                    </td>
                    <td>
                        <asp:DropDownList runat='server' ID='DropDownListSystemWide' ToolTip='Filter by System Wide Flag'>
                            <asp:ListItem Value='all' Text='All' />
                            <asp:ListItem Value='yes' Text='Yes' />
                            <asp:ListItem Value='no' Text='No' />
                        </asp:DropDownList>
                    </td>
                    <td>
                        <asp:Button ID="ButtonSearch" runat="server" Text=" Filter " OnClick="ButtonSearch_Click" />
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick="ButtonClear_Click" />
                    </td>
                </tr>
            </table>
            <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
            <asp:Panel runat='server' ID='PanelSearResults'  >
                <div style="text-align: right;" runat="server" id="pageSizeDiv">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl"  Visible="true" ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true" Visible="true" CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
        </div>
                <asp:GridView 
                    ID="GridViewQuestionGroups" 
                    runat="server" 
                    OnRowCommand = "GridViewQuestionGroups_RowCommand"
                    AutoGenerateColumns="False" Width="100%"
                    DataSourceID="DataSourceFilterQuestionGroups"
                    AllowPaging="True" 
                    AllowSorting="True" 
                    Visible="true" 
                    Caption="To sort please click table headings" 
                    EnableModelValidation="True"
                    DataKeyNames="TOOL_FORM_ID" 
                    onrowdatabound="GridViewQuestionGroups_RowDataBound">
                     <EmptyDataTemplate>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        No Question Groups Found. &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</EmptyDataTemplate>
                      <Columns>
                         <asp:TemplateField HeaderText="Edit" SortExpression="" AccessibleHeaderText='Edit'>
                            <ItemStyle HorizontalAlign="Center" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:LinkButton runat='server' ID='LinkButtonEdit' CommandName='Edit' 
                                CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TOOL_FORM_ID"))) %>' Text="Edit" 
                                 Enabled='<%# Convert.ToBoolean(Eval("EDITABLE_FLAG")) %>'
                                 Visible='<%# Convert.ToBoolean(Eval("EDITABLE_FLAG")) %>' />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Preview" SortExpression="" AccessibleHeaderText='Preview'>
                            <ItemStyle HorizontalAlign="Center" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:LinkButton runat='server' ID='LinkButtonPreview' CommandName='Preview' CommandArgument='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("TOOL_FORM_ID")) %>' Text="Preview Question Group" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Question Group ID" SortExpression="TOOL_FORM_ID">
                            <ItemStyle HorizontalAlign="Center" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle></ItemStyle>
                            <ItemTemplate>
                                <asp:Label ID="LabelFormID" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("TOOL_FORM_ID")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Question Group Name" SortExpression="NAME">
                            <ItemStyle HorizontalAlign="Left" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle ></ItemStyle>
                            <ItemTemplate>
                                <asp:Label ID="LabelFormName" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("NAME")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Question Group Notes" SortExpression="TITLE">
                            <ItemStyle HorizontalAlign="Left" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle ></ItemStyle>
                            <ItemTemplate>
                                <asp:Label ID="LabelFormTitle" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("TITLE")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Status" SortExpression="" AccessibleHeaderText="Status">
                            <ItemStyle HorizontalAlign="Center" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:Label ID="LabelStatus" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("status")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="System Wide" SortExpression="" AccessibleHeaderText="System Wide">
                            <ItemStyle HorizontalAlign="Center" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:Label ID="LabelSystemWide" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToBoolean(Eval("SYSTEM_WIDE_FLAG")) ? "Yes" : "No") %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Action" SortExpression="" AccessibleHeaderText='Delete'>
                            <ItemStyle HorizontalAlign="Center" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                               <asp:Button ID="ButtonDelete" runat="server"
                                    Text="  Delete  "
                                    Enabled = '<%# Convert.ToBoolean(Eval("EDITABLE_FLAG")) %>' Visible='<%# Convert.ToBoolean(Eval("EDITABLE_FLAG")) %>'
                                    OnClientClick="return confirm('Are you sure you want to delete this question group? Click cancel if you do not want to delete.');"
                                    ToolTip='<%# string.Format("Delete {0} from question group list", AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem,"NAME"))))  %>' 
                                    CommandName="DELETE_FLAG" 
                                    CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TOOL_FORM_ID"))) %>' 
                                    CausesValidation="false"/>
                               <asp:Button ID="ButtonDeactivate" runat="server"
                                    Text='<%# Convert.ToBoolean(Eval("ACTIVE_FLAG")) ? " Deactivate " : "  Activate  " %>' 
                                    Enabled = '<%# !Convert.ToBoolean(Eval("EDITABLE_FLAG")) %>' Visible='<%# !Convert.ToBoolean(Eval("EDITABLE_FLAG"))  %>'
                                    ToolTip='<%# string.Format("{0} {1} from question group list", Convert.ToBoolean(Eval("ACTIVE_FLAG")) ? " Deactivate " : "  Activate ", AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem,"NAME"))))   %>' 
                                    CommandName="UPDATE_FLAG" 
                                    CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TOOL_FORM_ID"))) %>' 
                                    CausesValidation="false"/>
                          </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <FooterStyle HorizontalAlign='Right' BackColor='White' />
                </asp:GridView>
           </asp:Panel>
            <br />
        </asp:Panel>
            <br />
         <asp:LinkButton ID="ButtonAddQuestionGroupBottom" runat="server" Text="Add New Question Group" PostBackUrl="ToolQuestionGroupEdit.aspx?id=0" />
        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
        <asp:LinkButton ID="LinkButtonQuestionListBottom" runat="server" Text="Go to Question List" PostBackUrl="ToolQuestionList.aspx" />
       
         <asp:ObjectDataSource 
            ID="DataSourceFilterQuestionGroups" runat="server" 
                SelectMethod="SearchForms" 
                SelectCountMethod="SearchFormsCount"
                StartRowIndexParameterName="startRow" 
                MaximumRowsParameterName="maxRows" 
                SortParameterName="sort"
                EnablePaging="True"  
                TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager">
            <SelectParameters>
                <asp:ControlParameter ControlID="TextBoxKeyWords" Name="keyWords" PropertyName="Text" Type="String" />
                <asp:ControlParameter ControlID="DropDownListStatus" Name="status" PropertyName="SelectedValue" Type="String" />
                <asp:ControlParameter ControlID="DropDownListSystemWide" Name="systemWide" PropertyName="SelectedValue" Type="String" />
                <asp:Parameter Name="sort" Type="String" />
                <asp:Parameter Name="startRow" Type="Int32" />
                <asp:Parameter Name="maxRows" Type="Int32" />
           </SelectParameters>
        </asp:ObjectDataSource>    
    </div>
</asp:Content>
